/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import java.util.List;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OrcEntity
extends Monster {
    public static final EntityDataAccessor<Integer> ORK_SIZE = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DOUBLE_HAND_ATTACK = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> INVENTORY_ITEM_ID = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final SimpleContainer inventory = new SimpleContainer(1);

    public OrcEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.m_252801_();
    }

    public static AttributeSupplier.Builder createOrkAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.225).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 38.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OrcEscapeGoal(this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new OrcAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new OrcGroupGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderAroundVeryFarGoal(this, 0.9, 0.7f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, WanderingTrader.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{OrcEntity.class}));
    }

    public static boolean canSpawn(EntityType<OrcEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return OrcEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && world.m_45527_(pos) || spawnReason == MobSpawnType.SPAWNER;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ORK_SIZE, (Object)1);
        this.f_19804_.m_135372_(DOUBLE_HAND_ATTACK, (Object)false);
        this.f_19804_.m_135372_(INVENTORY_ITEM_ID, (Object)-1);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSize(tag.m_128451_("OrkSize"), false);
        if (tag.m_128425_("OrcItem", 10)) {
            this.inventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("OrcItem")));
            this.setItemId(this.inventory.m_8020_(0).m_41720_());
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("OrkSize", this.getSize());
        if (!this.inventory.m_8020_(0).m_41619_()) {
            tag.m_128365_("OrcItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    public boolean m_6785_(double distanceSquared) {
        return this.inventory.m_8020_(0).m_41619_();
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ORK_SIZE);
    }

    public void setSize(int size, boolean healOrc) {
        this.f_19804_.m_135381_(ORK_SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_(16.0 + (double)size * 6.0);
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.26f - 0.012f * (float)size));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)size * 3.0 + 2.0);
        if (healOrc) {
            this.m_21153_(this.m_21233_());
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (ORK_SIZE.equals(data)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
        }
        super.m_7350_(data);
    }

    protected float m_6121_() {
        return 0.3f * (float)this.getSize();
    }

    public float m_6100_() {
        return 1.6f - 0.2f * (float)this.getSize();
    }

    protected SoundEvent m_7515_() {
        return SoundInit.ORC_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.ORC_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.ORC_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.ORC_STEP_EVENT, 1.0f, 1.0f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.82f * dimensions.f_20378_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        this.setSize(this.m_217043_().m_188503_(3) + 1, true);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(0.55f * (float)this.getSize());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_213780_().m_188503_(3) == 0 && !((Boolean)this.f_19804_.m_135370_(DOUBLE_HAND_ATTACK)).booleanValue()) {
            this.f_19804_.m_135381_(DOUBLE_HAND_ATTACK, (Object)true);
        } else {
            this.f_19804_.m_135381_(DOUBLE_HAND_ATTACK, (Object)false);
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public int m_5792_() {
        return 4;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null && !this.inventory.m_7983_()) {
            this.m_19983_(this.inventory.m_8020_(0));
        }
    }

    public boolean isBigOrc() {
        return this.getSize() == 3;
    }

    private void setItemId(Item item) {
        this.f_19804_.m_135381_(INVENTORY_ITEM_ID, (Object)BuiltInRegistries.f_257033_.m_7447_((Object)item));
    }

    private class OrcEscapeGoal
    extends Goal {
        protected final OrcEntity orcEntity;
        protected final double speed;
        protected double targetX;
        protected double targetY;
        protected double targetZ;

        public OrcEscapeGoal(OrcEntity orcEntity2, double speed) {
            this.orcEntity = orcEntity2;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.orcEntity.isBigOrc() || this.orcEntity.inventory.m_7983_() || this.orcEntity.m_9236_().m_45930_((Entity)this.orcEntity, 16.0) == null) {
                return false;
            }
            return this.findTarget();
        }

        protected boolean findTarget() {
            Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.orcEntity, (int)14, (int)4);
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.f_82479_;
            this.targetY = vec3d.f_82480_;
            this.targetZ = vec3d.f_82481_;
            return true;
        }

        public void m_8056_() {
            this.orcEntity.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        public boolean m_8045_() {
            if (this.orcEntity.m_9236_().m_45930_((Entity)this.orcEntity, 18.0) == null) {
                return false;
            }
            return !this.orcEntity.m_21573_().m_26571_();
        }
    }

    private class OrcAttackGoal
    extends MeleeAttackGoal {
        private final OrcEntity orcEntity;

        public OrcAttackGoal(OrcEntity orcEntity2, double speed, boolean pauseWhenMobIdle) {
            super((PathfinderMob)orcEntity2, speed, pauseWhenMobIdle);
            this.orcEntity = orcEntity2;
        }

        protected double m_6639_(LivingEntity entity) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() + entity.m_20205_();
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.m_25565_() <= 0) {
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                this.f_25540_.m_7327_((Entity)target);
                if (!this.orcEntity.isBigOrc() && this.orcEntity.inventory.m_7983_() && this.orcEntity.m_9236_().m_213780_().m_188501_() <= 0.3f && target instanceof Player) {
                    Player playerEntity = (Player)target;
                    for (int i = 45; i > 0; --i) {
                        if (playerEntity.m_150109_().m_8020_(i).m_41619_() || !(playerEntity.m_150109_().m_8020_(i).m_41720_() instanceof TieredItem) || !(playerEntity.m_9236_().m_213780_().m_188501_() < 0.3f)) continue;
                        this.orcEntity.inventory.m_6836_(0, playerEntity.m_150109_().m_8020_(i));
                        this.orcEntity.setItemId(this.orcEntity.inventory.m_8020_(0).m_41720_());
                        playerEntity.m_150109_().m_6836_(i, ItemStack.f_41583_);
                        break;
                    }
                }
            }
        }
    }

    private class OrcGroupGoal
    extends Goal {
        private final OrcEntity orcEntity;
        private int moveDelay;
        private int checkSurroundingDelay;
        private OrcEntity orcLeader;

        public OrcGroupGoal(OrcEntity orcEntity2) {
            this.orcEntity = orcEntity2;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(orcEntity2);
        }

        private int getSurroundingSearchDelay(OrcEntity orcEntity) {
            return 200 + orcEntity.m_217043_().m_188503_(200) % 20;
        }

        private boolean isCloseEnoughToOrcLeader() {
            return this.orcEntity.m_20270_((Entity)this.orcLeader) <= 10.0f;
        }

        public boolean m_8036_() {
            if (this.orcEntity.getSize() == 3 || this.orcEntity.m_5912_()) {
                return false;
            }
            if (this.orcLeader != null && this.isCloseEnoughToOrcLeader()) {
                return false;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            List list = this.orcEntity.m_9236_().m_45976_(((Object)((Object)this.orcEntity)).getClass(), this.orcEntity.m_20191_().m_82377_(30.0, 8.0, 30.0));
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((OrcEntity)((Object)list.get(i))).getSize() != 3) continue;
                    this.orcLeader = (OrcEntity)((Object)list.get(i));
                    return true;
                }
                this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.orcEntity);
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.orcLeader != null || this.orcEntity.m_21188_() == null) {
                return !this.isCloseEnoughToOrcLeader();
            }
            return false;
        }

        public void m_8056_() {
            this.moveDelay = 0;
        }

        public void m_8041_() {
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.orcEntity);
        }

        public void m_8037_() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = 20;
                if (this.orcLeader != null) {
                    this.orcEntity.m_21573_().m_5624_((Entity)this.orcLeader, 1.0);
                }
            }
        }
    }

    public class WanderAroundVeryFarGoal
    extends RandomStrollGoal {
        protected final float probability;
        private final OrcEntity orcEntity;

        public WanderAroundVeryFarGoal(OrcEntity orcEntity, double speed, float probability) {
            super((PathfinderMob)orcEntity, speed);
            this.probability = probability;
            this.orcEntity = orcEntity;
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (this.orcEntity.m_20072_()) {
                Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.orcEntity, (int)15, (int)7);
                return vec3d == null ? super.m_7037_() : vec3d;
            }
            return this.orcEntity.m_217043_().m_188501_() >= this.probability && this.orcEntity.isBigOrc() ? DefaultRandomPos.m_148403_((PathfinderMob)this.orcEntity, (int)30, (int)5) : super.m_7037_();
        }
    }
}

